define([
    'underscore',
    'backbone',
    'Global',
    'User',
    'modules/appointments/messages/request-message',
], function(_, Backbone, Global, User, Message) {
    'use strict';

    return Backbone.Collection.extend({
        model: Message,
        getVeteranMessageCount: function() {
            return _.filter(this.models, function(message) {
                return message.isVetMessage();
            }).length;
        },
        parse: function(data) {
            var vetId = User.get('id');
            var senderId = null;
            var previousId = null;

            _.each(data.appointmentRequestMessage, function(message) {
                message.messageSent = message.senderId === vetId;
                message.isLastMessage = false;
                senderId = (message.senderId === vetId ? vetId : '!' + vetId);
                if (senderId !== previousId) {
                    message.isLastMessage = true;
                    previousId = (message.senderId === vetId ? vetId : '!' + vetId);
                }
            });
            return data.appointmentRequestMessage;
        },
    });
});
